package cn.datax.service.workflow.api.dto;

import cn.datax.service.workflow.api.enums.VariablesEnum;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

@ApiModel(value = "创建流程实例Model")
@Data
public class ProcessInstanceCreateRequest implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "流程定义ID")
    private String processDefinitionId;
    @ApiModelProperty(value = "业务ID")
    private String businessKey;
    @ApiModelProperty(value = "业务类型")
    private String businessType;
    @ApiModelProperty(value = "业务名称")
    private String businessName;
    @ApiModelProperty(value = "流程参数")
    private Map<String, Object> variables = new HashMap<>();

    public ProcessInstanceCreateRequest() {}

    public ProcessInstanceCreateRequest(String processDefinitionId, String businessKey, String businessType, String businessName, Map<String, Object> var){
        setProcessDefinitionId(processDefinitionId);
        setBusinessKey(businessKey);
        setBusinessType(businessType);
        setBusinessName(businessName);
        variables.putAll(var);
        variables.put(VariablesEnum.businessKey.toString(), businessKey);
        variables.put(VariablesEnum.businessType.toString(), businessType);
        variables.put(VariablesEnum.businessName.toString(), businessName);
    }
}
