package cn.datax.service.data.market.controller;

import cn.datax.common.base.BaseController;
import cn.datax.common.core.R;
import cn.datax.common.security.annotation.DataInner;
import cn.datax.service.data.market.api.vo.ApiMaskVo;
import cn.datax.service.data.market.api.vo.DataApiVo;
import cn.datax.service.data.market.service.ApiMaskService;
import cn.datax.service.data.market.service.DataApiService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping("/inner")
public class InnerController extends BaseController {

    @Autowired
    private DataApiService dataApiService;

    @Autowired
    private ApiMaskService apiMaskService;

    /**
     * 通过ID查询信息
     *
     * @param id
     * @return
     */
    @DataInner
    @GetMapping("/dataApi/{id}")
    public R getDataApiById(@PathVariable String id) {
        DataApiVo dataApiVo = dataApiService.getDataApiById(id);
        return R.ok().setData(dataApiVo);
    }

    /**
     * 通过ID查询信息
     *
     * @param apiId
     * @return
     */
    @DataInner
    @GetMapping("/apiMask/{apiId}")
    public R getApiMaskByApiId(@PathVariable String apiId) {
        ApiMaskVo apiMaskVo = apiMaskService.getApiMaskByApiId(apiId);
        return R.ok().setData(apiMaskVo);
    }
}
