package cn.datax.common.mybatis.config;

import cn.datax.common.utils.SecurityUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import org.apache.ibatis.reflection.MetaObject;

import java.time.LocalDateTime;

public class DataMetaObjectHandler implements MetaObjectHandler {

	@Override
	public void insertFill(MetaObject metaObject) {
		this.setInsertFieldValByName("createTime", LocalDateTime.now(), metaObject);
		this.setInsertFieldValByName("updateTime", LocalDateTime.now(), metaObject);
		this.setInsertFieldValByName("status", 1, metaObject);

		String userId = getUserId();
		if(StrUtil.isNotBlank(userId)){
			this.setInsertFieldValByName("createBy", userId, metaObject);
			this.setInsertFieldValByName("updateBy", userId, metaObject);
		}
	}

	@Override
	public void updateFill(MetaObject metaObject) {
		this.setUpdateFieldValByName("updateTime", LocalDateTime.now(), metaObject);
		String userId = getUserId();
		if(StrUtil.isNotBlank(userId)){
			this.setInsertFieldValByName("updateBy", userId, metaObject);
		}
	}

	private String getUserId() {
		String userId = SecurityUtil.getUserId();
		return userId;
	}
}
