package cn.datax.service.data.market.config;

import cn.datax.service.data.market.service.ApiCallEngine;
import cn.datax.service.data.market.service.ApiLogService;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
public class ApiHandlerConfig {

    @Bean
    public MappingHandlerMapping mappingHandlerMapping(RequestMappingHandlerMapping requestMappingHandlerMapping, ObjectMapper objectMapper,
                                                       ApiCallEngine apiCallEngine, RedisTemplate redisTemplate, ApiLogService apiLogService) {
        MappingHandlerMapping mappingHandlerMapping = new MappingHandlerMapping();
        mappingHandlerMapping.setHandler(requestHandler(apiCallEngine, redisTemplate, apiLogService, objectMapper));
        mappingHandlerMapping.setRequestMappingHandlerMapping(requestMappingHandlerMapping);
        return mappingHandlerMapping;
    }

    @Bean
    public RequestHandler requestHandler(ApiCallEngine apiCallEngine, RedisTemplate redisTemplate, ApiLogService apiLogService, ObjectMapper objectMapper) {
        RequestHandler handler = new RequestHandler();
        handler.setApiCallEngine(apiCallEngine);
        handler.setApiLogService(apiLogService);
        handler.setObjectMapper(objectMapper);
        handler.setRequestInterceptor(new RequestInterceptor(redisTemplate));
        return handler;
    }
}
