package cn.datax.service.data.factory.sql.console.concurrent;

import cn.datax.service.data.factory.api.vo.SqlConsoleVo;
import lombok.extern.slf4j.Slf4j;

import java.sql.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

@Slf4j
public class DateHander extends CallableTemplate<SqlConsoleVo> {

    private CountDownLatch latch;

    private Connection conn;

    private String sql;

    public DateHander(CountDownLatch latch, Connection conn, String sql) {
        this.latch = latch;
        this.conn = conn;
        this.sql = sql;
    }

    @Override
    public SqlConsoleVo process() {
        log.info("执行sql:" + sql);
        long start = System.currentTimeMillis();
        Statement stmt = null;
        ResultSet rs = null;
        // 将查询数据存储到数据中
        List<Map<String, Object>> list = new ArrayList<>();
        // 新增、修改、删除受影响行数
        Integer updateCount = null;
        SqlConsoleVo sqlConsoleVo = new SqlConsoleVo();
        sqlConsoleVo.setSuccess(true);
        try {
            // 为了设置fetchSize，必须设置为false
            conn.setAutoCommit(false);
            stmt = conn.createStatement(ResultSet.TYPE_FORWARD_ONLY, ResultSet.CONCUR_READ_ONLY);
            stmt.setFetchSize(200);
            // 是否查询操作
            boolean execute = stmt.execute(sql);
            if (execute) {
                // 限制下最大数量
                stmt.setMaxRows(1000);
                rs = stmt.getResultSet();
                // 获取结果集的元数据信息
                ResultSetMetaData rsmd = rs.getMetaData();
                // 获取列字段的个数
                int colunmCount = rsmd.getColumnCount();
                // 存储列名的数组
                String[] columnNames = new String[colunmCount];
                for (int i = 0; i < colunmCount; i++) {
                    // 获取所有的字段名称
                    columnNames[i] = rsmd.getColumnLabel(i + 1);
                }
                while(rs.next()){
                    Map<String, Object> map = new HashMap<>();
                    for (int i = 0; i < colunmCount; i++) {
                        // 获取列名
                        String columnName = columnNames[i];
                        // 获取该列对应的值
                        Object value = rs.getObject(columnName);
                        map.put(columnName, value);
                    }
                    list.add(map);
                }
            } else {
                // 执行新增、修改、删除受影响行数
                updateCount = stmt.getUpdateCount();
            }
            conn.commit();
        } catch (SQLException e) {
            sqlConsoleVo.setSuccess(false);
            if(conn != null){
                try {
                    conn.rollback();
                } catch (SQLException e1) {
                }
            }
        } finally {
            if(rs != null){
                try {
                    rs.close();
                } catch (SQLException e) {
                }
            }
            if(stmt != null){
                try {
                    stmt.close();
                } catch (SQLException e) {
                }
            }
            if(conn != null){
                try {
                    conn.close();
                } catch (SQLException e) {
                }
            }
        }
        latch.countDown();
        long end = System.currentTimeMillis();
        log.info("线程查询数据用时:" + (end - start) + "ms");
        sqlConsoleVo.setSql(sql);
        sqlConsoleVo.setCount(updateCount);
        sqlConsoleVo.setData(list);
        sqlConsoleVo.setTime(end - start);
        return sqlConsoleVo;
    }
}
