package cn.datax.common.database.dialect;

import cn.datax.common.database.core.DbColumn;
import org.springframework.jdbc.core.RowMapper;

import java.sql.ResultSet;

/**
 * Postgre 数据库方言
 *
 * @author yuwei
 * @since 2020-03-14
 */
public class PostgreDialect extends AbstractDbDialect {

    @Override
    public String columns(String dbName, String tableName) {
        String sql = "SELECT a.attnum,\n" +
                "a.attname AS field,\n" +
                "t.typname AS type,\n" +
                "a.attlen AS length,\n" +
                "a.atttypmod AS lengthvar,\n" +
                "a.attnotnull AS notnull,\n" +
                "b.description AS comment\n" +
                "FROM pg_class c,\n" +
                "pg_attribute a\n" +
                "LEFT OUTER JOIN pg_description b ON a.attrelid=b.objoid AND a.attnum = b.objsubid,\n" +
                "pg_type t\n" +
                "WHERE c.relname = 'tableName'\n" +
                "and a.attnum > 0\n" +
                "and a.attrelid = c.oid\n" +
                "and a.atttypid = t.oid\n" +
                "ORDER BY a.attnum;";
        return sql;
    }

    @Override
    public String tables(String dbName) {
        return "SELECT tablename name FROM pg_tables WHERE schemaname = 'public' AND tableowner = '" + dbName + "' ";
    }

    @Override
    public String buildPaginationSql(String originalSql, long offset, long count) {
        StringBuilder sqlBuilder = new StringBuilder(originalSql);
        sqlBuilder.append(" LIMIT ").append(offset).append(" offset ").append(count);
        return sqlBuilder.toString();
    }

    @Override
    public RowMapper<DbColumn> rowMapper() {
        return (ResultSet rs, int rowNum) -> {
            DbColumn entity = new DbColumn();
            entity.setName(rs.getString("field"));
            entity.setType(rs.getString("type"));
            entity.setNullable(rs.getString("notnull"));
            return entity;
        };
    }
}
