package cn.datax.common.database.query;

import cn.datax.common.database.DbQuery;
import cn.datax.common.database.constants.DbType;

import java.util.EnumMap;
import java.util.Map;

public class QueryRegistry {

    private final Map<DbType, DbQuery> query_enum_map = new EnumMap<>(DbType.class);

    public QueryRegistry() {
        query_enum_map.put(DbType.MARIADB, new MariaDBQuery());
        query_enum_map.put(DbType.MYSQL, new MySqlQuery());
        query_enum_map.put(DbType.ORACLE_12C, new Oracle12cQuery());
        query_enum_map.put(DbType.ORACLE, new OracleQuery());
        query_enum_map.put(DbType.POSTGRE_SQL, new PostgreQuery());
        query_enum_map.put(DbType.SQL_SERVER2008, new SQLServer2008Query());
        query_enum_map.put(DbType.SQL_SERVER, new SQLServerQuery());
        query_enum_map.put(DbType.OTHER, new UnknownQuery());
    }

    public DbQuery getQuery(DbType dbType) {
        return query_enum_map.get(dbType);
    }
}
