package cn.datax.common.security.config;

import cn.datax.common.security.handler.DataAccessDeniedHandler;
import cn.datax.common.security.handler.DataAuthExceptionEntryPoint;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;

/**
 * 异常翻译配置
 *
 * @author yuwei
 * @since 2019/10/30
 */
@ComponentScan({"cn.datax.common.security.handler"})
public class DataAuthExceptionConfiguration {

    @Bean
    @ConditionalOnMissingBean(name = "accessDeniedHandler")
    public DataAccessDeniedHandler accessDeniedHandler() {
        return new DataAccessDeniedHandler();
    }

    @Bean
    @ConditionalOnMissingBean(name = "authenticationEntryPoint")
    public DataAuthExceptionEntryPoint authenticationEntryPoint() {
        return new DataAuthExceptionEntryPoint();
    }
}
