package cn.datax.common.database.dialect;

import cn.datax.common.database.DbDialect;

/**
 * 表数据查询抽象类
 *
 * @author yuwei
 * @since 2020-03-14
 */
public abstract class AbstractDbDialect implements DbDialect {

    @Override
    public String useDatabase(String dbName) {
        return "use `" + dbName + "`";
    }

    @Override
    public String columns(String dbName, String tableName) {
        return "show columns from `" + tableName + "`;";
    }

    @Override
    public String tables(String dbName) {
        return "show tables";
    }

    @Override
    public String version() {
        return "SELECT VERSION()";
    }

    @Override
    public String database() {
        return "show databases";
    }

    @Override
    public String buildPaginationSql(String sql, long offset, long count) {
        // 获取 分页实际条数
        StringBuilder builder = new StringBuilder(sql);
        builder.append(" LIMIT ").append(offset).append(" , ").append(count);
        return builder.toString();
    }

    @Override
    public String count(String sql) {
        return "SELECT COUNT(*) FROM ( " + sql + " ) TEMP";
    }
}
