package cn.datax.common.database.query;

import cn.datax.common.database.DbQuery;
import cn.datax.common.database.constants.DbType;

import java.util.EnumMap;
import java.util.Map;

public class QueryRegistry {

    private final Map<DbType, DbQuery> query_enum_map = new EnumMap<>(DbType.class);

    public QueryRegistry() {
        query_enum_map.put(DbType.MYSQL, new MySqlQuery());
    }

    public DbQuery getQuery(DbType dbType) {
        return query_enum_map.get(dbType);
    }
}
