package cn.datax.service.system.api.dto;

import cn.datax.common.validate.ValidateGroupForSave;
import cn.datax.common.validate.ValidateGroupForUpdate;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@ApiModel(value = "部门Model")
@Data
public class DeptDto implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "主键ID")
    @NotBlank(message = "主键ID不能为空", groups = {ValidateGroupForUpdate.class})
    private String id;

    @ApiModelProperty(value = "父部门ID")
    @NotBlank(message = "父部门ID不能为空", groups = {ValidateGroupForSave.class, ValidateGroupForUpdate.class})
    private String parentId;

    @ApiModelProperty(value = "部门名称")
    @NotBlank(message = "部门名称不能为空", groups = {ValidateGroupForSave.class, ValidateGroupForUpdate.class})
    private String deptName;

    @ApiModelProperty(value = "部门编码")
    @NotBlank(message = "部门编码不能为空", groups = {ValidateGroupForSave.class, ValidateGroupForUpdate.class})
    private String deptNo;
}
