package cn.datax.service.data.market.enums;

public enum WhereType {

    EQUALS(1, "=", "等于"),
    NOT_EQUALS(2, "!=", "不等于"),
    LIKE(3, "LIKE", "全模糊查询"),
    LIKE_LEFT(4, "LIKE_LEFT", "左模糊查询"),
    LIKE_RIGHT(5, "LIKE_RIGHT", "右模糊查询"),
    GREATER_THAN(6, ">", "大于"),
    GREATER_THAN_EQUALS(7, ">=", "大于等于"),
    LESS_THAN(8, "<", "小于"),
    LESS_THAN_EQUALS(9, "<=", "小于等于"),
    IN(10, "IN", "IN");

    private final Integer type;

    private final String key;

    private final String desc;

    WhereType(Integer type, String key, String desc) {
        this.type = type;
        this.key = key;
        this.desc = desc;
    }

    public static WhereType getWhereType(Integer whereType) {
        for (WhereType type : WhereType.values()) {
            if (type.type == whereType) {
                return type;
            }
        }
        return EQUALS;
    }
}
