package cn.datax.service.data.market.service.impl;

import cn.datax.common.core.R;
import cn.datax.common.database.DataSourceFactory;
import cn.datax.common.database.DbQuery;
import cn.datax.common.database.constants.DbQueryProperty;
import cn.datax.common.database.core.PageResult;
import cn.datax.common.exception.DataException;
import cn.datax.common.utils.PageUtil;
import cn.datax.common.utils.ThrowableUtil;
import cn.datax.service.data.factory.api.dto.DbSchema;
import cn.datax.service.data.factory.api.entity.DataSourceEntity;
import cn.datax.service.data.factory.api.feign.DataSourceServiceFeign;
import cn.datax.service.data.market.api.entity.DataApiEntity;
import cn.datax.service.data.market.dao.DataApiDao;
import cn.datax.service.data.market.service.ApiService;
import cn.datax.service.data.market.utils.SqlBuilderUtil;
import cn.datax.service.data.market.utils.ThreadUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;
import java.util.Optional;

@Slf4j
@Service
public class ApiServiceImpl implements ApiService {

    @Autowired
    private DataSourceFactory dataSourceFactory;

    @Autowired
    private DataSourceServiceFeign dataSourceServiceFeign;

    @Autowired
    private DataApiDao dataApiDao;

    @Override
    public PageResult<Map<String, Object>> v1() {
        // 缓存取数据
//        redisTemplate.opsForValue().get("myCache::userName")

        DataApiEntity dataApiEntity = dataApiDao.selectById(ThreadUtil.getInstance().get().getApiId());
        R result = dataSourceServiceFeign.getDataSourceById(dataApiEntity.getExecuteConfig().getSourceId());
        if(result == null || !result.isSuccess() || ObjectUtil.isEmpty(result.getData())){
            ThreadUtil.getInstance().get().setStatus(0);
            ThreadUtil.getInstance().get().setMsg("API调用查询数据源{"+dataApiEntity.getExecuteConfig().getSourceId()+"}出错");
            throw new DataException("API调用查询数据源出错");
        }
        DataSourceEntity dataSource = JSON.parseObject(JSON.toJSONString(result.getData()), DataSourceEntity.class);
        DbSchema dbSchema = dataSource.getDbSchema();
        DbQueryProperty dbQueryProperty = new DbQueryProperty(dataSource.getDbType(), dbSchema.getHost(),
                dbSchema.getUsername(), dbSchema.getPassword(), dbSchema.getPort(), dbSchema.getDbName());
        DbQuery dbQuery = dataSourceFactory.createDbQuery(dbQueryProperty);
        // 接收参数
        Map<String, Object> params = JSON.parseObject(ThreadUtil.getInstance().get().getCallerParams());
        // 分页参数
        Integer pageNum = (Integer) Optional.ofNullable(params.get("pageNum")).orElse(1);
        Integer pageSize = (Integer) Optional.ofNullable(params.get("pageSize")).orElse(20);
        PageUtil pageUtil = new PageUtil(pageNum, pageSize);
        Integer offset = pageUtil.getOffset();
        SqlBuilderUtil.SqlFilterResult sqlFilterResult;
        try {
            sqlFilterResult = SqlBuilderUtil.getInstance().applyFilters(dataApiEntity.getExecuteConfig().getSqlText(), params);
        } catch (Exception e) {
            log.error("全局异常信息ex={}, StackTrace={}", e.getMessage(), ThrowableUtil.getStackTrace(e));
            ThreadUtil.getInstance().get().setStatus(0);
            ThreadUtil.getInstance().get().setMsg(e.getMessage());
            throw new DataException("API调用动态构造SQL语句出错");
        }
        Object[] args = new Object[] {};
        Map<String, Object> acceptedFilters = sqlFilterResult.getAcceptedFilters();
        args = acceptedFilters.values().toArray();
        try {
            PageResult<Map<String, Object>> pageResult = dbQuery.queryByPage(sqlFilterResult.getSql(), args, offset, pageSize);
            pageResult.setPageNum(pageNum).setPageSize(pageSize);
            return pageResult;
        } catch (Exception e) {
            log.error("全局异常信息ex={}, StackTrace={}", e.getMessage(), ThrowableUtil.getStackTrace(e));
            ThreadUtil.getInstance().get().setStatus(0);
            ThreadUtil.getInstance().get().setMsg(e.getMessage());
            throw new DataException("API调用查询结果集出错");
        }
    }
}
