package cn.datax.learning.design.patterns.structural.flyweight;

import java.util.concurrent.ConcurrentHashMap;

public class ShapeFactory {

    private static final ConcurrentHashMap<String, Shape> circleMap = new ConcurrentHashMap<>();

    public static Shape getCircle(String color) {
        Circle circle = (Circle)circleMap.get(color);

        if(circle == null) {
            circle = new Circle(color);
            circleMap.put(color, circle);
            System.out.println("Creating circle of color : " + color);
        }
        return circle;
    }
}
