package cn.datax.service.data.market.api.enums;

public enum AlgorithmCrypt {

    EMAIL(1, "邮箱");

    private final Integer key;

    private final String val;

    AlgorithmCrypt(Integer key, String val) {
        this.key = key;
        this.val = val;
    }

    public Integer getKey() {
        return key;
    }

    public String getVal() {
        return val;
    }

    public static AlgorithmCrypt getDataType(Integer algorithmCrypt) {
        for (AlgorithmCrypt type : AlgorithmCrypt.values()) {
            if (type.key == algorithmCrypt) {
                return type;
            }
        }
        return EMAIL;
    }
}
