package cn.datax.service.email.api.feign.fallback;

import cn.datax.common.core.R;
import cn.datax.service.email.api.entity.EmailEntity;
import cn.datax.service.email.api.feign.EmailServiceFeign;
import lombok.Setter;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Slf4j
@Component
public class EmailServiceFeignFallbackImpl implements EmailServiceFeign {

    @Setter
    private Throwable cause;

    @Override
    public R sendMail(EmailEntity mail) {
        log.error("feign 发送邮件失败", cause);
        return null;
    }
}
