package cn.datax.service.data.quality.api.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;

import java.io.Serializable;
import java.time.LocalDateTime;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * <p>
 * 核查报告信息表
 * </p>
 *
 * @author yuwei
 * @since 2020-09-27
 */
@Data
@Accessors(chain = true)
@TableName("quality_check_report")
public class CheckReportEntity implements Serializable {

    private static final long serialVersionUID=1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private String id;

    /**
     * 核查规则主键
     */
    private String checkRuleId;

    /**
     * 核查时间
     */
    private LocalDateTime checkDate;

    /**
     * 核查结果
     */
    private String checkResult;

    /**
     * 核查数量
     */
    private Integer checkTotalCount;

    /**
     * 报错数量
     */
    private Integer checkErrorCount;
}
