package cn.datax.service.data.market.api.enums;

public enum CipherType {

    REGEX(1, "正则替换"),
    ALGORITHM(2, "加密算法");

    private final Integer key;

    private final String val;

    CipherType(Integer key, String val) {
        this.key = key;
        this.val = val;
    }

    public Integer getKey() {
        return key;
    }

    public String getVal() {
        return val;
    }

    public static CipherType getCipherType(Integer cipherType) {
        for (CipherType type : CipherType.values()) {
            if (type.key == cipherType) {
                return type;
            }
        }
        return REGEX;
    }
}
