package cn.datax.service.data.market.api.feign;

import cn.datax.common.core.R;
import cn.datax.service.data.market.api.feign.factory.ApiMaskServiceFeignFallbackFactory;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@FeignClient(contextId = "apiMaskServiceFeign", value = "datax-service-data-masking", fallbackFactory = ApiMaskServiceFeignFallbackFactory.class)
public interface ApiMaskServiceFeign {

    @GetMapping("/inner/apiMask/{id}")
    R getApiMaskById(@PathVariable("id") String id);
}
