package cn.datax.service.system.service;

import cn.datax.common.base.BaseService;
import cn.datax.common.base.DataScope;
import cn.datax.service.system.api.dto.UserDto;
import cn.datax.service.system.api.dto.UserPasswordDto;
import cn.datax.service.system.api.entity.UserEntity;
import cn.datax.service.system.api.vo.UserInfo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;

import java.util.Map;

/**
 * <p>
 *  服务类
 * </p>
 *
 * @author yuwei
 * @since 2019-09-04
 */
public interface UserService extends BaseService<UserEntity> {

    void saveUser(UserDto user);

    void updateUser(UserDto user);

    void deleteUserById(String id);

    void updateUserPassword(UserPasswordDto user);

    UserInfo getUserByUsername(String username);

    IPage<UserEntity> pageDataScope(IPage<UserEntity> page, Wrapper<UserEntity> queryWrapper, DataScope dataScope);

    Map<String, Object> getRouteById(String id);
}
