package cn.datax.common.security.interceptor;

import cn.datax.common.core.DataConstant;
import cn.datax.common.core.R;
import cn.datax.common.utils.ResponseUtil;
import cn.hutool.core.util.StrUtil;
import org.springframework.http.MediaType;
import org.springframework.util.Base64Utils;
import org.springframework.web.servlet.HandlerInterceptor;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

public class DataServerProtectInterceptor implements HandlerInterceptor {

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws IOException {
        // 从请求头中获取 Zuul Token
        String token = request.getHeader(DataConstant.GATEWAY_TOKEN_HEADER);
        String zuulToken = new String(Base64Utils.encode(DataConstant.GATEWAY_TOKEN_VALUE.getBytes()));
        // 校验 Zuul Token的正确性
        if (StrUtil.equals(zuulToken, token)) {
            return true;
        } else {
            ResponseUtil.makeResponse(
                    response, MediaType.APPLICATION_JSON_UTF8_VALUE,
                    HttpServletResponse.SC_FORBIDDEN, R.error("请通过网关获取资源"));
            return false;
        }
    }
}
