package cn.datax.service.system.controller;

import cn.datax.common.core.R;
import cn.datax.common.validate.ValidateGroupForSave;
import cn.datax.common.validate.ValidateGroupForUpdate;
import cn.datax.service.system.api.dto.DeptDto;
import cn.datax.service.system.api.entity.DeptEntity;
import cn.datax.service.system.mapstruct.DeptMapper;
import cn.datax.service.system.service.DeptService;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2019-09-04
 */
@RestController
@RequestMapping("/depts")
public class DeptController extends BaseController {

    @Autowired
    private DeptService deptService;

    @Autowired
    private DeptMapper deptMapper;

    @GetMapping("/{id}")
    public R getDeptById(@PathVariable String id) {
        DeptEntity deptEntity = deptService.getById(id);
        return R.ok().setData(deptMapper.toVO(deptEntity));
    }

    @GetMapping()
    public R getDeptList() {
        return R.ok().setData(deptService.list(Wrappers.emptyWrapper()));
    }

    @PostMapping()
    public R saveDept(@RequestBody @Validated({ValidateGroupForSave.class}) DeptDto dept) {
        deptService.saveDept(dept);
        return R.ok();
    }

    @PutMapping("/{id}")
    public R updateDept(@PathVariable String id, @RequestBody @Validated({ValidateGroupForUpdate.class}) DeptDto dept) {
        deptService.updateDept(dept);
        return R.ok();
    }

    @DeleteMapping("/{id}")
    public R deleteDept(@PathVariable String id) {
        deptService.deleteDeptById(id);
        return R.ok();
    }

}

