package cn.datax.service.system.controller;

import cn.datax.common.core.R;
import cn.datax.common.validate.ValidateGroupForSave;
import cn.datax.common.validate.ValidateGroupForUpdate;
import cn.datax.service.system.api.dto.PostDto;
import cn.datax.service.system.api.entity.PostEntity;
import cn.datax.service.system.mapstruct.PostMapper;
import cn.datax.service.system.service.PostService;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2019-09-11
 */
@RestController
@RequestMapping("/posts")
public class PostController extends BaseController {

    @Autowired
    private PostService postService;

    @Autowired
    private PostMapper postMapper;

    @GetMapping("/{id}")
    public R getPostById(@PathVariable String id) {
        PostEntity postEntity = postService.getById(id);
        return R.ok().setData(postMapper.toVO(postEntity));
    }

    @GetMapping("/page")
    public R getPostPage(@RequestParam(value="pageNum", defaultValue="1") Integer pageNum,
                         @RequestParam(value="pageSize", defaultValue="20") Integer pageSize,
                         PostEntity post) {
        QueryWrapper<PostEntity> queryWrapper = Wrappers.emptyWrapper();
        queryWrapper.like(StrUtil.isNotBlank(post.getPostName()), "post_name", post.getPostName());
        IPage<PostEntity> page = postService.page(new Page<>(pageNum, pageSize), queryWrapper);
        return R.ok().setData(page);
    }

    @PostMapping()
    public R savePost(@RequestBody @Validated({ValidateGroupForSave.class}) PostDto post) {
        postService.savePost(post);
        return R.ok();
    }

    @PutMapping("/{id}")
    public R updatePost(@PathVariable String id, @RequestBody @Validated({ValidateGroupForUpdate.class}) PostDto post) {
        postService.updatePost(post);
        return R.ok();
    }

    @DeleteMapping("/{id}")
    public R deletePost(@PathVariable String id) {
        postService.deletePostById(id);
        return R.ok();
    }

}

