package cn.datax.service.system.controller;

import cn.datax.common.core.R;
import cn.datax.common.validate.ValidateGroupForSave;
import cn.datax.common.validate.ValidateGroupForUpdate;
import cn.datax.service.system.api.dto.RoleDto;
import cn.datax.service.system.api.entity.RoleEntity;
import cn.datax.service.system.mapstruct.RoleMapper;
import cn.datax.service.system.service.RoleService;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;

/**
 * <p>
 *  前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2019-09-04
 */
@RestController
@RequestMapping("/roles")
public class RoleController extends BaseController {

    @Autowired
    private RoleService roleService;

    @Autowired
    private RoleMapper roleMapper;

    /**
     * 通过ID查询角色信息
     * @param id
     * @return
     */
    @GetMapping("/{id}")
    public R getRoleById(@PathVariable String id) {
        RoleEntity roleEntity = roleService.getById(id);
        return R.ok().setData(roleMapper.toVO(roleEntity));
    }

    /**
     * 分页查询角色信息
     * @param pageNum
     * @param pageSize
     * @param role
     * @return
     */
    @GetMapping("/page")
    public R getRolePage(@RequestParam(value="pageNum", defaultValue="1") Integer pageNum,
                         @RequestParam(value="pageSize", defaultValue="20") Integer pageSize,
                         RoleEntity role) {
        QueryWrapper<RoleEntity> queryWrapper = Wrappers.emptyWrapper();
        queryWrapper.like(StrUtil.isNotBlank(role.getRoleName()), "role_name", role.getRoleName());
        IPage<RoleEntity> page = roleService.page(new Page<>(pageNum, pageSize), queryWrapper);
        return R.ok().setData(page);
    }

    /**
     * 添加角色
     * @param role
     * @return
     */
    @PostMapping()
    public R saveRole(@RequestBody @Validated({ValidateGroupForSave.class}) RoleDto role) {
        roleService.saveRole(role);
        return R.ok();
    }

    /**
     * 修改角色
     * @param role
     * @return
     */
    @PutMapping("/{id}")
    public R updateRole(@PathVariable String id, @RequestBody @Validated({ValidateGroupForUpdate.class}) RoleDto role) {
        roleService.updateRole(role);
        return R.ok();
    }

    /**
     * 删除角色
     * @param id
     * @return
     */
    @DeleteMapping("/{id}")
    public R deleteRole(@PathVariable String id) {
        roleService.deleteRoleById(id);
        return R.ok();
    }

}

