package cn.datax.service.system.service.impl;

import cn.datax.service.system.api.entity.SysConfigEntity;
import cn.datax.service.system.api.dto.SysConfigDto;
import cn.datax.service.system.service.SysConfigService;
import cn.datax.service.system.mapstruct.SysConfigMapper;
import cn.datax.service.system.dao.SysConfigDao;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 * 系统参数配置信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-05-19
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class SysConfigServiceImpl extends BaseServiceImpl<SysConfigDao, SysConfigEntity> implements SysConfigService {

    @Autowired
    private SysConfigDao sysConfigDao;

    @Autowired
    private SysConfigMapper sysConfigMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveSysConfig(SysConfigDto sysConfigDto) {
        SysConfigEntity sysConfig = sysConfigMapper.toEntity(sysConfigDto);
        sysConfigDao.insert(sysConfig);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateSysConfig(SysConfigDto sysConfigDto) {
        SysConfigEntity sysConfig = sysConfigMapper.toEntity(sysConfigDto);
        sysConfigDao.updateById(sysConfig);
    }

    @Override
    public SysConfigEntity getSysConfigById(String id) {
        SysConfigEntity sysConfigEntity = super.getById(id);
        return sysConfigEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSysConfigById(String id) {
        sysConfigDao.deleteById(id);
    }
}
