package cn.datax.common.log.async;

import cn.datax.service.system.api.dto.LogDto;
import cn.datax.service.system.api.feign.LogServiceFeign;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Component
public class AsyncTask {

    @Autowired
    private LogServiceFeign logServiceFeign;
	
	@Async("dataLogExecutor")
    public void doTask(LogDto logDto) {
		log.info("开始做任务--模拟日志");
        long start = System.currentTimeMillis();
		log.info("日志体{}", logDto.toString());
        logServiceFeign.saveLog(logDto);
        long end = System.currentTimeMillis();
        log.info("完成任务，耗时：" + (end - start) + "毫秒");
    }

}