package cn.datax.service.data.factory.service;

import cn.datax.common.database.DbQuery;
import cn.datax.service.data.factory.api.dto.DataSourceDto;
import cn.datax.service.data.factory.api.entity.DataSourceEntity;
import cn.datax.common.base.BaseService;

/**
 * <p>
 * 数据源信息表 服务类
 * </p>
 *
 * @author yuwei
 * @since 2020-03-14
 */
public interface DataSourceService extends BaseService<DataSourceEntity> {

    void saveDataSource(DataSourceDto dataSource);

    void updateDataSource(DataSourceDto dataSource);

    void deleteDataSourceById(String id);

    DbQuery checkConnection(DataSourceDto dataSource);

    DbQuery getDbQuery(String id);
}
