package cn.datax.service.data.masterdata.service.impl;

import cn.datax.service.data.masterdata.api.query.ModelDataQuery;
import cn.datax.service.data.masterdata.dao.MysqlDynamicDao;
import cn.datax.service.data.masterdata.service.ModelDataService;
import cn.datax.service.data.masterdata.utils.SearchUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

@Service
public class ModelDataServiceImpl implements ModelDataService {

    @Autowired
    private MysqlDynamicDao dynamicDao;

    @Override
    public IPage<Map<String, Object>> getPageModelDatas(ModelDataQuery modelDataQuery) {
        String tableName = modelDataQuery.getTableName();
        QueryWrapper queryWrapper = SearchUtil.parseWhereSql(modelDataQuery);
        IPage<Map<String, Object>> page = dynamicDao.getPageModelDatas(new Page<>(modelDataQuery.getPageNum(), modelDataQuery.getPageSize()), queryWrapper, tableName);
        return page;
    }
}
