package cn.datax.service.system.api.dto;

import cn.datax.common.validate.ValidateGroupForSave;
import cn.datax.common.validate.ValidateGroupForUpdate;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.io.Serializable;

@Data
public class PostDto implements Serializable {

    private static final long serialVersionUID=1L;

    @NotBlank(message = "主键ID不能为空", groups = {ValidateGroupForUpdate.class})
    private String id;

    @NotBlank(message = "岗位名称不能为空", groups = {ValidateGroupForSave.class, ValidateGroupForUpdate.class})
    private String postName;

}
