package cn.datax.service.system.service.impl;

import cn.datax.service.system.api.dto.DeptDto;
import cn.datax.service.system.api.entity.DeptEntity;
import cn.datax.service.system.mapper.DeptMapper;
import cn.datax.service.system.service.DeptService;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2019-09-04
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class DeptServiceImpl extends BaseServiceImpl<DeptMapper, DeptEntity> implements DeptService {

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveDept(DeptDto deptDto) {
        DeptEntity dept = new DeptEntity();
        BeanUtils.copyProperties(deptDto, dept);
        baseMapper.insert(dept);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDept(DeptDto deptDto) {
        DeptEntity dept = new DeptEntity();
        BeanUtils.copyProperties(deptDto, dept);
        baseMapper.updateById(dept);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDeptById(String id) {
        baseMapper.deleteById(id);
    }
}
