package cn.datax.service.system.service.impl;

import cn.datax.service.system.api.dto.PostDto;
import cn.datax.service.system.api.entity.PostEntity;
import cn.datax.service.system.mapper.PostMapper;
import cn.datax.service.system.service.PostService;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 *  服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2019-09-11
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class PostServiceImpl extends BaseServiceImpl<PostMapper, PostEntity> implements PostService {

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void savePost(PostDto postDto) {
        PostEntity post = new PostEntity();
        BeanUtils.copyProperties(postDto, post);
        baseMapper.insert(post);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updatePost(PostDto postDto) {
        PostEntity post = new PostEntity();
        BeanUtils.copyProperties(postDto, post);
        baseMapper.updateById(post);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deletePostById(String id) {
        baseMapper.deleteById(id);
    }
}
