package cn.datax.service.data.market.api.call.factory;

import cn.datax.service.data.market.api.call.factory.crypto.Crypto;
import cn.datax.service.data.market.api.call.factory.crypto.RegexRegistry;
import cn.datax.service.data.market.api.enums.RegexCrypto;

public class RegexFactory extends AbstractFactory {

    private static final RegexRegistry REGEX_REGISTRY = new RegexRegistry();

    @Override
    public Crypto getCrypto(Integer type) {
        RegexCrypto crypto = RegexCrypto.getRegexCrypto(type);
        return REGEX_REGISTRY.getRegex(crypto);
    }
}
