package cn.datax.common.core;

public class DataConstant {

    /**
     * Oauth2安全相关常量
     */
    public enum Security {
        //请求头TOKEN名称
        TOKENHEADER("tokenHeader", "gatewayToken"),
        //请求头TOKEN值
        TOKENVALUE("tokenValue", "datax:gateway:123456"),
        //OAUTH2令牌类型
        TOKENTYPE("tokenType", "bearer "),
        //security授权角色前缀
        ROLEPREFIX("rolePrefix", "ROLE_");
        Security(String key, String val){
            this.key = key;
            this.val = val;
        }

        private final String key;
        private final String val;

        public String getKey() {
            return key;
        }

        public String getVal() {
            return val;
        }
    }

    /**
     * 通用的是否
     */
    public enum TrueOrFalse {
        FALSE(0,false),
        TRUE(1,true);
        TrueOrFalse(Integer key, boolean val){
            this.key = key;
            this.val = val;
        }

        private final Integer key;
        private final boolean val;

        public Integer getKey() {
            return key;
        }

        public boolean getVal() {
            return val;
        }
    }

    /**
     * 用户认证返回额外信息
     */
    public enum UserAdditionalInfo {
        LICENSE("license", "许可证"),
        USER("user", "用户"),
        USERID("user_id", "用户ID"),
        USERNAME("username", "用户名"),
        NICKNAME("nickname", "用户昵称"),
        DEPT("user_dept", "用户部门"),
        ROLE("user_role", "用户角色"),
        POST("user_post", "用户岗位");
        UserAdditionalInfo(String key, String val){
            this.key = key;
            this.val = val;
        }

        private final String key;
        private final String val;

        public String getKey() {
            return key;
        }

        public String getVal() {
            return val;
        }
    }

    /**
     * 通用的启用禁用状态
     */
    public enum EnableState {
        DISABLE(0,"禁用"),
        ENABLE(1,"启用");
        EnableState(Integer key, String val){
            this.key = key;
            this.val = val;
        }

        private final Integer key;
        private final String val;

        public Integer getKey() {
            return key;
        }

        public String getVal() {
            return val;
        }
    }
}
