package cn.datax.service.data.market.controller;

import cn.datax.common.base.BaseController;
import cn.datax.common.core.R;
import cn.datax.service.data.market.api.vo.ApiHeader;
import cn.datax.service.data.market.service.ApiExecuteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/apis")
public class ApiExecuteController extends BaseController {

    @Autowired
    private ApiExecuteService apiExecuteService;

    @GetMapping(value = "/{id}/header")
    public R getApiHeader(@PathVariable String id){
        ApiHeader apiHeader = apiExecuteService.getApiHeader(id);
        return R.ok().setData(apiHeader);
    }

    @PostMapping(value = "/{id}/register")
    public R apiRegister(@PathVariable String id){
        apiExecuteService.registerApi(id);
        return R.ok();
    }

    @PostMapping(value = "/{id}/unregister")
    public R apiUnRegister(@PathVariable String id){
        apiExecuteService.unRegisterApi(id);
        return R.ok();
    }
}
