package cn.datax.service.email.controller;

import cn.datax.common.base.BaseController;
import cn.datax.common.core.R;
import cn.datax.common.utils.ThrowableUtil;
import cn.datax.service.email.api.dto.EmailDto;
import cn.datax.service.email.api.entity.EmailEntity;
import cn.datax.service.email.mapstruct.EmailMapper;
import cn.datax.service.email.utils.EmailUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Slf4j
@RestController
@RequestMapping("/inner")
public class InnerController extends BaseController {

    @Autowired
    private EmailMapper emailMapper;

    @Autowired
    private EmailUtil emailUtil;

    @PostMapping("/sendMail")
    public R sendMail(@RequestBody EmailDto mail) {
        EmailEntity emailEntity = emailMapper.toEntity(mail);
        try {
            emailUtil.sendEmail(emailEntity);
            return R.ok();
        } catch (Exception e) {
            log.error("全局异常信息ex={}, StackTrace={}", e.getMessage(), ThrowableUtil.getStackTrace(e));
            return R.error(e.getMessage());
        }
    }
}
