package cn.datax.service.data.market.api.dto;

import cn.datax.common.validate.ValidationGroups;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.io.Serializable;

@ApiModel(value = "字段信息Model")
@Data
public class FieldParam implements Serializable {

    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "字段名称")
    @NotBlank(message = "字段名称不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String fieldName;
    @ApiModelProperty(value = "作为请求参数")
    @NotNull(message = "作为请求参数不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String reqable;
    @ApiModelProperty(value = "作为返回参数")
    @NotNull(message = "作为返回参数不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String resable;
    @ApiModelProperty(value = "字段类型")
    @NotBlank(message = "字段类型不能为空", groups = {ValidationGroups.Insert.class, ValidationGroups.Update.class})
    private String fieldType;
}
