(function(root, factory) {
  if (typeof define === 'function' && define.amd) {
    // AMD. Register as an anonymous module.
    define(['exports', 'echarts'], factory)
  } else if (typeof exports === 'object' && typeof exports.nodeName !== 'string') {
    // CommonJS
    factory(exports, require('echarts'))
  } else {
    // Browser globals
    factory({}, root.echarts)
  }
}(this, function(exports, echarts) {
  var log = function(msg) {
    if (typeof console !== 'undefined') {
      console && console.error && console.error(msg)
    }
  }
  if (!echarts) {
    log('ECharts is not Loaded')
    return
  }
  echarts.registerTheme('westeros', {
    'color': [
      '#516b91',
      '#59c4e6',
      '#edafda',
      '#93b7e3',
      '#a5e7f0',
      '#cbb0e3'
    ],
    'backgroundColor': 'rgba(0,0,0,0)',
    'textStyle': {},
    'title': {
      'textStyle': {
        'color': '#516b91'
      },
      'subtextStyle': {
        'color': '#93b7e3'
      }
    },
    'line': {
      'itemStyle': {
        'borderWidth': '2'
      },
      'lineStyle': {
        'width': '2'
      },
      'symbolSize': '6',
      'symbol': 'emptyCircle',
      'smooth': true
    },
    'radar': {
      'itemStyle': {
        'borderWidth': '2'
      },
      'lineStyle': {
        'width': '2'
      },
      'symbolSize': '6',
      'symbol': 'emptyCircle',
      'smooth': true
    },
    'bar': {
      'itemStyle': {
        'barBorderWidth': 0,
        'barBorderColor': '#ccc'
      }
    },
    'pie': {
      'itemStyle': {
        'borderWidth': 0,
        'borderColor': '#ccc'
      }
    },
    'scatter': {
      'itemStyle': {
        'borderWidth': 0,
        'borderColor': '#ccc'
      }
    },
    'boxplot': {
      'itemStyle': {
        'borderWidth': 0,
        'borderColor': '#ccc'
      }
    },
    'parallel': {
      'itemStyle': {
        'borderWidth': 0,
        'borderColor': '#ccc'
      }
    },
    'sankey': {
      'itemStyle': {
        'borderWidth': 0,
        'borderColor': '#ccc'
      }
    },
    'funnel': {
      'itemStyle': {
        'borderWidth': 0,
        'borderColor': '#ccc'
      }
    },
    'gauge': {
      'itemStyle': {
        'borderWidth': 0,
        'borderColor': '#ccc'
      }
    },
    'candlestick': {
      'itemStyle': {
        'color': '#edafda',
        'color0': 'transparent',
        'borderColor': '#d680bc',
        'borderColor0': '#8fd3e8',
        'borderWidth': '2'
      }
    },
    'graph': {
      'itemStyle': {
        'borderWidth': 0,
        'borderColor': '#ccc'
      },
      'lineStyle': {
        'width': 1,
        'color': '#aaa'
      },
      'symbolSize': '6',
      'symbol': 'emptyCircle',
      'smooth': true,
      'color': [
        '#516b91',
        '#59c4e6',
        '#edafda',
        '#93b7e3',
        '#a5e7f0',
        '#cbb0e3'
      ],
      'label': {
        'color': '#eee'
      }
    },
    'map': {
      'itemStyle': {
        'normal': {
          'areaColor': '#f3f3f3',
          'borderColor': '#516b91',
          'borderWidth': 0.5
        },
        'emphasis': {
          'areaColor': '#a5e7f0',
          'borderColor': '#516b91',
          'borderWidth': 1
        }
      },
      'label': {
        'normal': {
          'textStyle': {
            'color': '#000'
          }
        },
        'emphasis': {
          'textStyle': {
            'color': '#516b91'
          }
        }
      }
    },
    'geo': {
      'itemStyle': {
        'normal': {
          'areaColor': '#f3f3f3',
          'borderColor': '#516b91',
          'borderWidth': 0.5
        },
        'emphasis': {
          'areaColor': '#a5e7f0',
          'borderColor': '#516b91',
          'borderWidth': 1
        }
      },
      'label': {
        'normal': {
          'textStyle': {
            'color': '#000'
          }
        },
        'emphasis': {
          'textStyle': {
            'color': '#516b91'
          }
        }
      }
    },
    'categoryAxis': {
      'axisLine': {
        'show': true,
        'lineStyle': {
          'color': '#cccccc'
        }
      },
      'axisTick': {
        'show': false,
        'lineStyle': {
          'color': '#333'
        }
      },
      'axisLabel': {
        'show': true,
        'textStyle': {
          'color': '#999999'
        }
      },
      'splitLine': {
        'show': true,
        'lineStyle': {
          'color': [
            '#eeeeee'
          ]
        }
      },
      'splitArea': {
        'show': false,
        'areaStyle': {
          'color': [
            'rgba(250,250,250,0.05)',
            'rgba(200,200,200,0.02)'
          ]
        }
      }
    },
    'valueAxis': {
      'axisLine': {
        'show': true,
        'lineStyle': {
          'color': '#cccccc'
        }
      },
      'axisTick': {
        'show': false,
        'lineStyle': {
          'color': '#333'
        }
      },
      'axisLabel': {
        'show': true,
        'textStyle': {
          'color': '#999999'
        }
      },
      'splitLine': {
        'show': true,
        'lineStyle': {
          'color': [
            '#eeeeee'
          ]
        }
      },
      'splitArea': {
        'show': false,
        'areaStyle': {
          'color': [
            'rgba(250,250,250,0.05)',
            'rgba(200,200,200,0.02)'
          ]
        }
      }
    },
    'logAxis': {
      'axisLine': {
        'show': true,
        'lineStyle': {
          'color': '#cccccc'
        }
      },
      'axisTick': {
        'show': false,
        'lineStyle': {
          'color': '#333'
        }
      },
      'axisLabel': {
        'show': true,
        'textStyle': {
          'color': '#999999'
        }
      },
      'splitLine': {
        'show': true,
        'lineStyle': {
          'color': [
            '#eeeeee'
          ]
        }
      },
      'splitArea': {
        'show': false,
        'areaStyle': {
          'color': [
            'rgba(250,250,250,0.05)',
            'rgba(200,200,200,0.02)'
          ]
        }
      }
    },
    'timeAxis': {
      'axisLine': {
        'show': true,
        'lineStyle': {
          'color': '#cccccc'
        }
      },
      'axisTick': {
        'show': false,
        'lineStyle': {
          'color': '#333'
        }
      },
      'axisLabel': {
        'show': true,
        'textStyle': {
          'color': '#999999'
        }
      },
      'splitLine': {
        'show': true,
        'lineStyle': {
          'color': [
            '#eeeeee'
          ]
        }
      },
      'splitArea': {
        'show': false,
        'areaStyle': {
          'color': [
            'rgba(250,250,250,0.05)',
            'rgba(200,200,200,0.02)'
          ]
        }
      }
    },
    'toolbox': {
      'iconStyle': {
        'normal': {
          'borderColor': '#999999'
        },
        'emphasis': {
          'borderColor': '#666666'
        }
      }
    },
    'legend': {
      'textStyle': {
        'color': '#999999'
      }
    },
    'tooltip': {
      'axisPointer': {
        'lineStyle': {
          'color': '#cccccc',
          'width': 1
        },
        'crossStyle': {
          'color': '#cccccc',
          'width': 1
        }
      }
    },
    'timeline': {
      'lineStyle': {
        'color': '#8fd3e8',
        'width': 1
      },
      'itemStyle': {
        'normal': {
          'color': '#8fd3e8',
          'borderWidth': 1
        },
        'emphasis': {
          'color': '#8fd3e8'
        }
      },
      'controlStyle': {
        'normal': {
          'color': '#8fd3e8',
          'borderColor': '#8fd3e8',
          'borderWidth': 0.5
        },
        'emphasis': {
          'color': '#8fd3e8',
          'borderColor': '#8fd3e8',
          'borderWidth': 0.5
        }
      },
      'checkpointStyle': {
        'color': '#8fd3e8',
        'borderColor': 'rgba(138,124,168,0.37)'
      },
      'label': {
        'normal': {
          'textStyle': {
            'color': '#8fd3e8'
          }
        },
        'emphasis': {
          'textStyle': {
            'color': '#8fd3e8'
          }
        }
      }
    },
    'visualMap': {
      'color': [
        '#516b91',
        '#59c4e6',
        '#a5e7f0'
      ]
    },
    'dataZoom': {
      'backgroundColor': 'rgba(0,0,0,0)',
      'dataBackgroundColor': 'rgba(255,255,255,0.3)',
      'fillerColor': 'rgba(167,183,204,0.4)',
      'handleColor': '#a7b7cc',
      'handleSize': '100%',
      'textStyle': {
        'color': '#333333'
      }
    },
    'markPoint': {
      'label': {
        'color': '#eee'
      },
      'emphasis': {
        'label': {
          'color': '#eee'
        }
      }
    }
  })
}))
