package cn.datax.learning.design.patterns.creational;

/**
 * 抽象工厂模式（Abstract Factory Pattern）
 * 提供一个创建一系列相关或相互依赖对象的接口，而无须指定他们具体的类。它针对的是有多个产品的等级结构。而工厂方法模式针对的是一个产品的等级结构。
 */
public class AbstractFactory {

    public static void main(String[] args) {
        AFactory bigerFactory = new BigerFactory();
        AFactory smallerFactory = new SmallerFactory();
        bigerFactory.produceHeadset().play();
        bigerFactory.produceXiaomoPhone().run();
        smallerFactory.produceXiaomoPhone().run();
        smallerFactory.produceHeadset().play();
    }
}

//抽象产品1
interface Headset {
    void play();
}

//抽象产品2
interface XiaomiPhone {
    void run();
}

//Headset具体产品*2
class EP21 implements Headset {
    @Override
    public void play() {
        System.out.println("我是一副EP21");
    }
}

class EP22 implements Headset {
    @Override
    public void play() {
        System.out.println("我是一副EP22");
    }
}

//XiaomiPhone具体产品*2
class MixPhone implements XiaomiPhone {
    @Override
    public void run() {
        System.out.println("我是一台MIXPhone");
    }
}

class MaxPhone implements XiaomiPhone {
    @Override
    public void run() {
        System.out.println("我是一台MaxPhone");
    }
}

//抽象工厂
interface AFactory {
    Headset produceHeadset();

    XiaomiPhone produceXiaomoPhone();
}

//Headset具体工厂*2
class SmallerFactory implements AFactory {
    @Override
    public Headset produceHeadset() {
        return new EP21();
    }

    @Override
    public XiaomiPhone produceXiaomoPhone() {
        return new MixPhone();
    }
}

class BigerFactory implements AFactory {
    @Override
    public Headset produceHeadset() {
        return new EP22();
    }

    @Override
    public XiaomiPhone produceXiaomoPhone() {
        return new MaxPhone();
    }
}