package cn.datax.learning.design.patterns.creational;

/**
 * 工厂模式（Factory Pattern）
 * 2.工厂方法模式
 * 是有一个抽象的父类定义公共接口，子类负责生成具体的对象，这样做的目的是将类的实例化操作延迟到子类中完成。
 */
public class FactoryMethod {

    public static void main(String[] args) {
        IFactory bigFactory = new BigFactory();
        bigFactory.produce().run();
        IFactory smallFactory = new SmallFactory();
        smallFactory.produce().run();
    }
}

//抽象产品类
interface HuweiPhone {
    void run();
}

//具体产品类
class Mate5 implements HuweiPhone {
    @Override
    public void run() {
        System.out.println("我是一台Mate5");
    }
}

//具体产品类
class Mate6 implements HuweiPhone {
    @Override
    public void run() {
        System.out.println("我是一台Mate6");
    }
}

//抽象的工厂
interface IFactory {
    HuweiPhone produce();
}

//工厂1
class BigFactory implements IFactory {
    @Override
    public HuweiPhone produce() {
        return new Mate5();
    }
}
//工厂2
class SmallFactory implements IFactory {
    @Override
    public HuweiPhone produce() {
        return new Mate6();
    }
}
