package cn.datax.learning.design.patterns.creational;

/**
 * 单例模式（Singleton Pattern）
 */
public class SingletonPattern {

    private SingletonPattern() {}

    /**
     * 懒汉式加载
     */
    private static SingletonPattern singleton;

    //线程不安全，不用于多线程使用（不推荐）
    public static SingletonPattern getInstance() {
        if(singleton == null) {
            singleton = new SingletonPattern();
        }
        return singleton;
    }

    //线程安全，同步方法（不推荐使用）
    public static synchronized SingletonPattern getInstance2() {
        if(singleton == null) {
            singleton = new SingletonPattern();
        }
        return singleton;
    }

    //线程安全，同步代码块（不可用）
    public static SingletonPattern getInstance3() {
        if(singleton == null) {
            synchronized(SingletonPattern.class) {
                singleton = new SingletonPattern();
            }
        }
        return singleton;
    }

    //线程安全，同步代码块，双重检查（推荐使用）
    public static SingletonPattern getInstance4() {
        if(singleton == null) {
            synchronized(SingletonPattern.class) {
                if(singleton == null) {
                    singleton = new SingletonPattern();
                }
            }
        }
        return singleton;
    }

    /**
     * 饿汉式加载
     */
    private static SingletonPattern singletonPattern = new SingletonPattern();

    //静态常量（可用）
    public static SingletonPattern getInstance5(){
        return singletonPattern;
    }

    //静态代码块（可用）
    static{
        singletonPattern = new SingletonPattern();
    }
    public static SingletonPattern getInstance6(){
        return singletonPattern;
    }

    //静态内部类（推荐用）
    private static class SingletonPatternIntance {
        private static final SingletonPattern INTANCE = new SingletonPattern();
    }

    public static SingletonPattern getInstance7(){
        return SingletonPatternIntance.INTANCE;
    }
}
