package cn.datax.service.system.service.impl;

import cn.datax.common.core.DataConstant;
import cn.datax.common.redis.service.RedisService;
import cn.datax.service.system.api.entity.DictEntity;
import cn.datax.service.system.api.dto.DictDto;
import cn.datax.service.system.service.DictService;
import cn.datax.service.system.mapstruct.DictMapper;
import cn.datax.service.system.dao.DictDao;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * <p>
 * 字典编码信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-04-17
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class DictServiceImpl extends BaseServiceImpl<DictDao, DictEntity> implements DictService {

    @Autowired
    private DictDao dictDao;

    @Autowired
    private DictMapper dictMapper;

    @Autowired
    private RedisService redisService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveDict(DictDto dictDto) {
        DictEntity dict = dictMapper.toEntity(dictDto);
        dictDao.insert(dict);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateDict(DictDto dictDto) {
        DictEntity dict = dictMapper.toEntity(dictDto);
        dictDao.updateById(dict);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteDictById(String id) {
        dictDao.deleteById(id);
    }

    @Override
    public void refreshDict() {
        List<DictEntity> dictEntityList = dictDao.queryDictList(DataConstant.EnableState.ENABLE.getKey());
        String key = "data:system:dicts";
        Boolean hasKey = redisService.hasKey(key);
        if (hasKey) {
            redisService.del(key);
        }
        redisService.lSet(key, dictEntityList);
    }
}
