package cn.datax.common.core;

import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.List;

@Data
@Accessors(chain = true)
public class JsonPage<T> implements Serializable {

    private static final long serialVersionUID = 1L;

    private long pageNum;
    private long pageSize;
    private long total;
    private List<T> data;

    public JsonPage(long pageNum, long pageSize, long total, List<T> data) {
        this.pageNum = pageNum;
        this.pageSize = pageSize;
        this.total = total;
        this.data = data;
    }
}
