import { login, logout, getRoutes } from '@/api/system/user'
import { getToken, setToken, removeToken } from '@/utils/auth'
import { resetRouter } from '@/router'
import Storage from 'good-storage'

const getDefaultState = () => {
  return {
    token: getToken(),
    detail: {},
    menus: [],
    perms: []
  }
}

const state = {
  token: getToken(),
  detail: Storage.get('data_ui_user_detail') || {},
  menus: Storage.get('data_ui_user_menus') || [],
  perms: Storage.get('data_ui_user_perms') || []
}

const mutations = {
  RESET_STATE: (state) => {
    Object.assign(state, getDefaultState())
  },
  SET_TOKEN: (state, token) => {
    state.token = token
  },
  SET_DETAIL: (state, detail) => {
    state.detail = detail
  },
  SET_MENUS: (state, menus) => {
    state.menus = menus
  },
  SET_PERMS: (state, perms) => {
    state.perms = perms
  }
}

const actions = {
  login({ commit }, userInfo) {
    const { username, password } = userInfo
    return new Promise((resolve, reject) => {
      login(username, password).then(response => {
        const { access_token, username, nickname, user_id, user_dept, user_post, user_role } = response
        commit('SET_TOKEN', access_token)
        setToken(access_token)
        const detail = {
          id: user_id || '',
          username: username || '',
          nickname: nickname || '',
          dept: user_dept || '',
          roles: user_role ? user_role.map(role => role.id) : [],
          posts: user_post || []
        }
        commit('SET_DETAIL', detail)
        Storage.set('data_ui_user_detail', detail)
        resolve()
      }).catch(error => {
        reject(error)
      })
    })
  },

  getInfo({ commit, state }) {
    return new Promise((resolve, reject) => {
      getRoutes(state.detail.id).then(response => {
        const { data } = response
        const perms = data.perms || []
        const routes = data.routes || []
        commit('SET_MENUS', routes)
        Storage.set('data_ui_user_menus', routes)
        commit('SET_PERMS', perms)
        Storage.set('data_ui_user_perms', perms)
        resolve()
      }).catch(error => {
        reject(error)
      })
    })
  },

  logout({ commit, state }) {
    return new Promise((resolve, reject) => {
      logout(state.token).then(() => {
        removeToken()
        resetRouter()
        commit('RESET_STATE')
        resolve()
      }).catch(error => {
        reject(error)
      })
    })
  },

  resetToken({ commit }) {
    return new Promise(resolve => {
      removeToken()
      commit('RESET_STATE')
      resolve()
    })
  }
}

export default {
  namespaced: true,
  state,
  mutations,
  actions
}

