package cn.datax.service.system.service.impl;

import cn.datax.service.system.api.entity.WorkflowConfigEntity;
import cn.datax.service.system.api.dto.WorkflowConfigDto;
import cn.datax.service.system.service.WorkflowConfigService;
import cn.datax.service.system.mapstruct.WorkflowConfigMapper;
import cn.datax.service.system.dao.WorkflowConfigDao;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 * 工作流配置信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-05-19
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class WorkflowConfigServiceImpl extends BaseServiceImpl<WorkflowConfigDao, WorkflowConfigEntity> implements WorkflowConfigService {

    @Autowired
    private WorkflowConfigDao workflowConfigDao;

    @Autowired
    private WorkflowConfigMapper workflowConfigMapper;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveWorkflowConfig(WorkflowConfigDto workflowConfigDto) {
        WorkflowConfigEntity workflowConfig = workflowConfigMapper.toEntity(workflowConfigDto);
        workflowConfigDao.insert(workflowConfig);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void updateWorkflowConfig(WorkflowConfigDto workflowConfigDto) {
        WorkflowConfigEntity workflowConfig = workflowConfigMapper.toEntity(workflowConfigDto);
        workflowConfigDao.updateById(workflowConfig);
    }

    @Override
    public WorkflowConfigEntity getWorkflowConfigById(String id) {
        WorkflowConfigEntity workflowConfigEntity = super.getById(id);
        return workflowConfigEntity;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteWorkflowConfigById(String id) {
        workflowConfigDao.deleteById(id);
    }
}
