package cn.datax.service.data.metadata.service.impl;

import cn.datax.service.data.metadata.api.dto.MetadataAuthorizeDto;
import cn.datax.service.data.metadata.api.entity.MetadataAuthorizeEntity;
import cn.datax.service.data.metadata.api.enums.DataLevel;
import cn.datax.service.data.metadata.service.MetadataAuthorizeService;
import cn.datax.service.data.metadata.mapstruct.MetadataAuthorizeMapper;
import cn.datax.service.data.metadata.dao.MetadataAuthorizeDao;
import cn.datax.common.base.BaseServiceImpl;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 数据授权信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-10-23
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class MetadataAuthorizeServiceImpl extends BaseServiceImpl<MetadataAuthorizeDao, MetadataAuthorizeEntity> implements MetadataAuthorizeService {

    @Autowired
    private MetadataAuthorizeDao metadataAuthorizeDao;

    @Autowired
    private MetadataAuthorizeMapper metadataAuthorizeMapper;

    @Override
    public List<String> getAuthorizedMetadata(String id) {
        List<MetadataAuthorizeEntity> metadataAuthorizeList = metadataAuthorizeDao.selectList(Wrappers.<MetadataAuthorizeEntity>lambdaQuery().eq(MetadataAuthorizeEntity::getRoleId, id));
        List<String> list = metadataAuthorizeList.stream().map(s -> s.getObjectId()).collect(Collectors.toList());
        return list;
    }

    @Override
    public void metadataAuthorize(MetadataAuthorizeDto metadataAuthorizeDto) {
        // 先删除
        metadataAuthorizeDao.delete(Wrappers.<MetadataAuthorizeEntity>lambdaQuery().eq(MetadataAuthorizeEntity::getRoleId, metadataAuthorizeDto.getRoleId()));
        metadataAuthorizeDto.getAuthorizeDataList().stream().forEach(s -> {
            MetadataAuthorizeEntity metadataAuthorizeEntity = new MetadataAuthorizeEntity();
            metadataAuthorizeEntity.setRoleId(s.getRoleId());
            metadataAuthorizeEntity.setObjectId(s.getObjectId());
            Integer level = DataLevel.getLevel(s.getObjectType()).getLevel();
            metadataAuthorizeEntity.setObjectType(String.valueOf(level));
            metadataAuthorizeDao.insert(metadataAuthorizeEntity);
        });
    }
}
