package cn.datax.service.data.standard.controller;

import cn.datax.common.core.JsonPage;
import cn.datax.common.core.R;
import cn.datax.common.validate.ValidationGroups;
import cn.datax.service.data.standard.api.dto.StandardDictDto;
import cn.datax.service.data.standard.api.entity.StandardDictEntity;
import cn.datax.service.data.standard.api.vo.StandardDictVo;
import cn.datax.service.data.standard.api.query.StandardDictQuery;
import cn.datax.service.data.standard.mapstruct.StandardDictMapper;
import cn.datax.service.data.standard.service.StandardDictService;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import cn.datax.common.base.BaseController;

import java.util.List;
import java.util.stream.Collectors;

/**
 * <p>
 * 标准信息表 前端控制器
 * </p>
 *
 * @author yuwei
 * @since 2020-08-10
 */
@Api(tags = {"标准信息表"})
@RestController
@RequestMapping("/standard/standardDict")
public class StandardDictController extends BaseController {

    @Autowired
    private StandardDictService standardDictService;

    @Autowired
    private StandardDictMapper standardDictMapper;

    /**
     * 通过ID查询信息
     *
     * @param id
     * @return
     */
    @ApiOperation(value = "获取详细信息", notes = "根据url的id来获取详细信息")
    @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path")
    @GetMapping("/{id}")
    public R getStandardDictById(@PathVariable String id) {
        StandardDictEntity standardDictEntity = standardDictService.getStandardDictById(id);
        return R.ok().setData(standardDictMapper.toVO(standardDictEntity));
    }

    /**
     * 分页查询信息
     *
     * @param standardDictQuery
     * @return
     */
    @ApiOperation(value = "分页查询", notes = "")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "standardDictQuery", value = "查询实体standardDictQuery", required = true, dataTypeClass = StandardDictQuery.class)
    })
    @GetMapping("/page")
    public R getStandardDictPage(StandardDictQuery standardDictQuery) {
        QueryWrapper<StandardDictEntity> queryWrapper = new QueryWrapper<>();
        queryWrapper.like(StrUtil.isNotBlank(standardDictQuery.getGbCode()), "gb_code", standardDictQuery.getGbCode());
        queryWrapper.like(StrUtil.isNotBlank(standardDictQuery.getGbName()), "gb_name", standardDictQuery.getGbName());
        queryWrapper.eq(StrUtil.isNotBlank(standardDictQuery.getTypeId()), "type_id", standardDictQuery.getTypeId());
        IPage<StandardDictEntity> page = standardDictService.page(new Page<>(standardDictQuery.getPageNum(), standardDictQuery.getPageSize()), queryWrapper);
        List<StandardDictVo> collect = page.getRecords().stream().map(standardDictMapper::toVO).collect(Collectors.toList());
        JsonPage<StandardDictVo> jsonPage = new JsonPage<>(page.getCurrent(), page.getSize(), page.getTotal(), collect);
        return R.ok().setData(jsonPage);
    }

    /**
     * 添加
     * @param standardDict
     * @return
     */
    @ApiOperation(value = "添加信息", notes = "根据standardDict对象添加信息")
    @ApiImplicitParam(name = "standardDict", value = "详细实体standardDict", required = true, dataType = "StandardDictDto")
    @PostMapping()
    public R saveStandardDict(@RequestBody @Validated({ValidationGroups.Insert.class}) StandardDictDto standardDict) {
        StandardDictEntity standardDictEntity = standardDictService.saveStandardDict(standardDict);
        return R.ok().setData(standardDictMapper.toVO(standardDictEntity));
    }

    /**
     * 修改
     * @param standardDict
     * @return
     */
    @ApiOperation(value = "修改信息", notes = "根据url的id来指定修改对象，并根据传过来的信息来修改详细信息")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path"),
            @ApiImplicitParam(name = "standardDict", value = "详细实体standardDict", required = true, dataType = "StandardDictDto")
    })
    @PutMapping("/{id}")
    public R updateStandardDict(@PathVariable String id, @RequestBody @Validated({ValidationGroups.Update.class}) StandardDictDto standardDict) {
        StandardDictEntity standardDictEntity = standardDictService.updateStandardDict(standardDict);
        return R.ok().setData(standardDictMapper.toVO(standardDictEntity));
    }

    /**
     * 删除
     * @param id
     * @return
     */
    @ApiOperation(value = "删除", notes = "根据url的id来指定删除对象")
    @ApiImplicitParam(name = "id", value = "ID", required = true, dataType = "String", paramType = "path")
    @DeleteMapping("/{id}")
    public R deleteStandardDictById(@PathVariable String id) {
        standardDictService.deleteStandardDictById(id);
        return R.ok();
    }

    /**
     * 批量删除
     * @param ids
     * @return
     */
    @ApiOperation(value = "批量删除角色", notes = "根据url的ids来批量删除对象")
    @ApiImplicitParam(name = "ids", value = "ID集合", required = true, dataType = "List", paramType = "path")
    @DeleteMapping("/batch/{ids}")
    public R deleteStandardDictBatch(@PathVariable List<String> ids) {
        standardDictService.deleteStandardDictBatch(ids);
        return R.ok();
    }
}
