package cn.datax.service.workflow.flowable;

import cn.datax.common.utils.SpringContextHolder;
import lombok.extern.slf4j.Slf4j;
import org.flowable.engine.TaskService;
import org.flowable.task.service.delegate.DelegateTask;
import org.flowable.task.service.delegate.TaskListener;

@Slf4j
public class InitialAuditCreateTaskListener implements TaskListener {

    @Override
    public void notify(DelegateTask delegateTask) {
        log.info("进入初审节点用户任务启动监听器");
        TaskService taskService = SpringContextHolder.getBean(TaskService.class);
        taskService.setAssignee(delegateTask.getId(), "1214835832967581698");
//        taskService.addCandidateUser(delegateTask.getId(), "");
//        taskService.addCandidateGroup(delegateTask.getId(), "");
        log.info("Variables：{}", delegateTask.getVariables());
        log.info("任务执行人：{}", delegateTask.getAssignee());
        log.info("任务配置ID: {}", delegateTask.getTaskDefinitionKey());
        log.info("退出初审节点用户任务启动监听器");
    }
}
