package cn.datax.commo.office.word;

import com.aspose.words.Document;
import com.aspose.words.License;
import com.aspose.words.SaveFormat;
import com.aspose.words.SaveOptions;

import java.io.*;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class WordUtil {

    private WordUtil() {}

    private static volatile WordUtil instance;

    public static WordUtil getInstance() {
        if(instance == null) {
            synchronized (WordUtil.class) {
                if(instance == null) {
                    instance = new WordUtil();
                }
            }
        }
        return instance;
    }

    /**
     * 去除水印
     */
    static {
        try {
            new License().setLicense(new ByteArrayInputStream("license".getBytes("UTF-8")));
        } catch (Exception e) {}
    }

    /**
     * 普通数据模板 返回缓冲输入流
     *
     * @param name
     * @param value
     * @param modelPath 模板文件 F:\模板.docx
     * @return 缓冲输入流 供controller层下载
     * @throws Exception
     */
    public ByteArrayInputStream fillWordData(String[] name, Object[] value, String modelPath) throws Exception {
        Document doc = new MergeDataSource().load(name, value, modelPath);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        doc.save(bos, SaveOptions.createSaveOptions(SaveFormat.DOCX));
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        return bis;
    }

    /**
     * 普通数据模板 直接保存到指定位置
     *
     * @param name
     * @param value
     * @param modelPath 模板文件 F:\模板.docx
     * @param destPath 保存文件 F:\测试.docx
     * @throws Exception
     */
    public void fillWordData(String[] name, Object[] value, String modelPath, String destPath) throws Exception {
        Document doc = new MergeDataSource().load(name, value, modelPath);
        doc.save(destPath, SaveOptions.createSaveOptions(SaveFormat.DOCX));
    }

    /**
     * 带集合的数据模板 返回缓冲输入流
     *
     * @param name
     * @param value
     * @param modelPath 模板文件 F:\模板.docx
     * @param dataList 集合数据
     * @param tableName 集合名称
     * @throws Exception
     */
    public ByteArrayInputStream fillWordListData(String[] name, Object[] value, String modelPath, List<Map<String, Object>> dataList, String tableName) throws Exception {
        Document doc = new MergeDataSource().load(name, value, modelPath, dataList, tableName);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        doc.save(bos, SaveOptions.createSaveOptions(SaveFormat.DOCX));
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        return bis;
    }

    /**
     * 带集合的数据模板 直接保存到指定位置
     *
     * @param name
     * @param value
     * @param modelPath 模板文件 F:\模板.docx
     * @param destPath 保存文件 F:\测试.docx
     * @param dataList 集合数据
     * @param tableName 集合名称
     * @throws Exception
     */
    public void fillWordListData(String[] name, Object[] value, String modelPath, String destPath, List<Map<String, Object>> dataList, String tableName) throws Exception {
        Document doc = new MergeDataSource().load(name, value, modelPath, dataList, tableName);
        doc.save(destPath, SaveOptions.createSaveOptions(SaveFormat.DOCX));
    }

    /**
     * word转pdf
     * @param srcPath 文件路径 F:\\test\\审批流提交.docx
     * @param destPath 目标路径 F:\\test\\20200420.pdf
     * @throws Exception
     */
    public void word2pdf(String srcPath, String destPath) throws Exception {
        // 转换开始前时间
        long old = System.currentTimeMillis();
        // 要转换的word文档的路径
        Document doc = new Document(srcPath);
        // 全面支持DOC, DOCX, OOXML, RTF HTML, OpenDocument, PDF, EPUB, XPS, SWF 相互转换
        doc.save(destPath, SaveOptions.createSaveOptions(SaveFormat.PDF));
        // 转换结束后时间
        long now = System.currentTimeMillis();
        System.out.println("共耗时：" + ((now - old) / 1000.0) + "秒");
    }

    /**
     * 创建空文档
     *
     * @param destPath 文件路径 F:\\test\\审批流提交.docx
     * @return
     */
    public boolean newWord(String destPath) {
        try {
            Document doc = new Document();
            doc.save(destPath, SaveOptions.createSaveOptions(SaveFormat.DOCX));
            return true;
        } catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) throws Exception {
        Map<String, Object> map = new HashMap<>();
        map.put("companyName", "测试");
        map.put("totalSalary", new BigDecimal("12.34"));
        List<Map<String, Object>> list = new ArrayList<>();
        Map<String, Object> map1 = new HashMap<>();
        map1.put("name", "测试1");
        map1.put("age", 12);
        map1.put("sex", "男");
        map1.put("salary", new BigDecimal("5.0"));
        list.add(map1);
        Map<String, Object> map2 = new HashMap<>();
        map2.put("name", "测试2");
        map2.put("age", 14);
        map2.put("sex", "女");
        map2.put("salary", new BigDecimal("7.34"));
        list.add(map2);
        WordUtil.getInstance().fillWordListData(new String[]{"companyName", "totalSalary"}, new Object[]{"测试", new BigDecimal("12.34")}, "F:\\test\\模板.docx", "F:\\test\\123.docx", list, "workerList");
//        WordUtil.getInstance().word2pdf("F:\\test\\审批流提交.docx", "F:\\test\\20200420.pdf");
    }
}
