const path = require('path')
const defaultSettings = require('./src/settings.js')

const resolve = function (dir) {
  return path.join(__dirname, dir)
}

const name = defaultSettings.title || 'Template'

const port = defaultSettings.port || 9528

module.exports = {
  publicPath: process.env.NODE_ENV === 'production' ? '/vue-template/' : '/',
  outputDir: 'dist',
  assetsDir: 'static',
  lintOnSave: process.env.NODE_ENV === 'development', // 是否开启eslint保存检测
  productionSourceMap: false, // 是否在构建生产包时生成sourcdeMap
  configureWebpack: {
    name: name,
    resolve: {
      alias: {
        '@': resolve('src'),
        'views': resolve('src/views')
      }
    }
  },
  chainWebpack: config => {
    config.resolve.alias
      .set('@', resolve('src'))
      .set('views', resolve('src/views'))
    config.module
      .rule('svg')
      .exclude.add(resolve('src/icons'))
      .end()
    config.module
      .rule('icons')
      .test(/\.svg$/)
      .include.add(resolve('src/icons'))
      .end()
      .use('svg-sprite-loader')
      .loader('svg-sprite-loader')
      .options({
        symbolId: 'icon-[name]'
      })
      .end()
    config.module
      .rule('vue')
      .use('vue-loader')
      .loader('vue-loader')
      .tap(options => {
        options.compilerOptions.preserveWhitespace = true
        return options
      })
      .end()
    config.optimization.runtimeChunk('single')
  },
  devServer: {
    port: port,
    open: false,
    overlay: {
      warnings: false,
      errors: true
    },
    proxy: {
      // change xxx-api/login => /login
      [process.env.VUE_APP_BASE_API]: {
        // easy-mock 1234@abcd
        target: `http://192.168.1.200:8612/`,
        changeOrigin: true,
        pathRewrite: {
          ['^' + process.env.VUE_APP_BASE_API]: ''
        }
      }
    }
  }
}
