package cn.datax.service.data.quality.service.impl;

import cn.datax.service.data.quality.api.entity.CheckReportEntity;
import cn.datax.service.data.quality.service.CheckReportService;
import cn.datax.service.data.quality.mapstruct.CheckReportMapper;
import cn.datax.service.data.quality.dao.CheckReportDao;
import cn.datax.common.base.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

/**
 * <p>
 * 核查报告信息表 服务实现类
 * </p>
 *
 * @author yuwei
 * @since 2020-09-27
 */
@Service
@Transactional(propagation = Propagation.SUPPORTS, readOnly = true, rollbackFor = Exception.class)
public class CheckReportServiceImpl extends BaseServiceImpl<CheckReportDao, CheckReportEntity> implements CheckReportService {

    @Autowired
    private CheckReportDao checkReportDao;

    @Autowired
    private CheckReportMapper checkReportMapper;

    @Override
    public CheckReportEntity getCheckReportById(String id) {
        CheckReportEntity checkReportEntity = super.getById(id);
        return checkReportEntity;
    }
}
